const express = require('express');
const mysql = require('mysql2/promise');
const bcrypt = require('bcrypt');
const jwt = require('jsonwebtoken');
const cors = require('cors');

const app = express();
const port = 3000;

const pool =  mysql.createPool({
  host: 'localhost',
  user: 'williams_mejias',
  password: 'wMej_!234',
  database: 'williams_sistemas',
  connectionLimit: 25,
});


app.use(express.json());
app.use(cors());



// Ruta para iniciar sesión y obtener un token
app.post('/login', async(req, res) => {
  try {
    const { rut, password } = req.body;
    const connection = await pool.getConnection();
    console.log('Conexión obtenida de la piscina.');

    const [results] = await connection.query('SELECT rut,nombre,sk,tipo FROM usuarios WHERE rut = ?', [rut]);

    console.log(results.length);
    if (results.length === 0) {
      connection.release();
      res.status(401).json({ error: 'Credenciales inválidas' });
      return;
    }

    const user = results[0];
    console.log(user)
    //const match = bcrypt.compareSync('1234', '$2a$10$70kizYu7aIWghI9SYo8EYO1FHolRAkC7Xop06DlDVlafn.DSB3Ebu');

    const match = bcrypt.compareSync(password, user.sk); // Comparar contraseñas

    if (!match) {
      connection.release();
      res.status(401).json({ error: 'Credenciales inválidas' });
      return;
    }

    const token = jwt.sign({ rut: user.rut }, 'clave_secreta');
    console.log(token); // Imprimir el token aquí
    const tipo=user.tipo;
    const usuario=user.rut;
    res.json({ token,tipo,usuario});

    connection.release();
    console.log('Conexión liberada y devuelta a la piscina.');
  } catch (error) {
    res.json({ message: error });
  }
});







// Middleware para verificar el token en cada solicitud
app.use((req, res, next) => {
  const token = req.headers.authorization;

  if (token) {
    jwt.verify(token, 'clave_secreta', (err, decoded) => {
      if (err) {
        res.status(401).json({ error: 'Token inválido' });
      } else {
        req.user = decoded;
        next();
      }
    });
  } else {
    res.status(401).json({ error: 'Token requerido' });
  }
});

// Ruta protegida que requiere autenticación
app.get('/protected', (req, res) => {
  res.json({ message: 'Acceso permitido', user: req.user });
});


app.get('/usuarios', async (req, res) => {
   try{
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');

        const [results] = await connection.query('SELECT rut,nombre,tipo,estado FROM usuarios');
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        
        res.json(results);
   }catch (error) {
        res.json({ message: error });
   }
  });


  app.post('/registrarUsuario', async(req, res) => {
    try{
        const { rut,nombre,tipo,password,sk} = req.body;
        const usuario = { rut,nombre,tipo,password,sk};
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.'); 
       
        const [results] = await connection.query('INSERT INTO usuarios SET ?', usuario);
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        
        console.log(results); 
        res.json({ message: 'Usuario registrado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
    }
  });

  
  app.post('/editarUsuario', async(req, res) => {
    try{
        const { rut,nombre,tipo,estado} = req.body;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  
      //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};
  
      const [results] = await connection.query(
        `
        UPDATE usuarios
        SET 
            nombre = ?,
            tipo = ?,
            estado = ?
            
        WHERE rut = ?
          `,  [nombre, tipo, estado, rut]

          );
  
          connection.release();
          console.log('Conexión liberada y devuelta a la piscina.');
          console.log(results); // Puedes mostrar los resultados si lo deseas
          // Envía una respuesta al cliente
          res.json({ message: 'Trabajador editado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
      console.log(error)
    }
  });
  
  
    app.post('/cambiarClaveUsuario', async(req, res) => {
    try{
        const {rut,password,sk} = req.body;
        const usuario = {rut,password,sk};
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.'); 
       
        const [results] = await connection.query(
        `
        UPDATE usuarios
        SET 
            password = ?,
            sk = ?
        WHERE rut = ?
          `,  [password, sk, rut]

          );
  
          connection.release();
          console.log('Conexión liberada y devuelta a la piscina.');
          console.log(results); // Puedes mostrar los resultados si lo deseas
          // Envía una respuesta al cliente
          res.json({ message: 'Clave editada exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
    }
  });

  


  app.get('/sueldoMinimo', async (req, res) => {
    try{
         const connection = await pool.getConnection();
         console.log('Conexión obtenida de la piscina.');
 
         const [results] = await connection.query('SELECT * FROM sueldominimo');
         connection.release();
         console.log('Conexión liberada y devuelta a la piscina.');
         
         res.json(results);
    }catch (error) {
         res.json({ message: error });
    }
   });
 


////TRABAJADORES

  app.post('/registrarTrabajador', async(req, res) => {
    try {
       
        const { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,comuna,estadoCivil,foto,telefono,correo,imagen,imgFirma,tipoPago,banco,tipoCuenta,numeroCuenta,imagen2,fechaCreacion,sueldo,descripcionTrabajo,usuario} = req.body;
        const imageData = imgFirma.split(';base64,').pop();
        const firma = Buffer.from(imageData, 'base64');

        const imagen2Data=imagen2.split(';base64,').pop();
        const foto2=Buffer.from(imagen2Data, 'base64');
        const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,comuna,estadoCivil,foto,telefono,correo,imagen,firma,tipoPago,banco,tipoCuenta,numeroCuenta,foto2,fechaCreacion,sueldo,descripcionTrabajo,usuario};
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  
      
        const [results] = await connection.query('INSERT INTO trabajadores SET ?', user);
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Trabajador registrado exitosamente' });
    
    } catch (error) {
      console.log(error)
      res.json({ message: error });
    }
   
  });
  
  app.post('/editarTrabajador', async(req, res) => {
    try{
        const { rut,nombre,nacimiento,nacionalidad,fechaCreacion,afp,salud,domicilio,comuna,estado,foto,telefono,correo,imagen,imgFirma,imagen2} = req.body;
        const imageData = imgFirma.split(';base64,').pop();
        const firma = Buffer.from(imageData, 'base64');
        const imagen2Data=imagen2.split(';base64,').pop();
        const foto2=Buffer.from(imagen2Data, 'base64');
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  
        console.log(firma)
      //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};
  
      const [results] = await connection.query(
        `
        UPDATE trabajadores
        SET nombre = ?,
            nacimiento = ?,
            nacionalidad = ?,
            fechaCreacion=?,
            afp = ?,
            salud = ?,
            domicilio = ?,
            comuna = ?,
            estadoCivil = ?,
            foto2 = ?,
            telefono = ?,
            correo = ?,
            imagen = ?,
            firma = ?
        WHERE rut = ?
          `,  [nombre, nacimiento, nacionalidad, fechaCreacion,afp, salud, domicilio, comuna, estado, foto2, telefono, correo, imagen, firma, rut]

          );
  
          connection.release();
          console.log('Conexión liberada y devuelta a la piscina.');
          console.log(results); // Puedes mostrar los resultados si lo deseas
          // Envía una respuesta al cliente
          res.json({ message: 'Trabajador editado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
      console.log(error)
    }
  });


  app.post('/editarTrabajadorSF', async(req, res) => {
    try{
        const { rut,nombre,nacimiento,nacionalidad,fechaCreacion,afp,salud,domicilio,comuna,estado,foto,telefono,correo,imagen,tipoPago,banco,tipoCuenta,numeroCuenta} = req.body;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  
      //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};
  
      const [results] = await connection.query(
        `
        UPDATE trabajadores
        SET nombre = ?,
            nacimiento = ?,
            nacionalidad = ?,
            fechaCreacion=?,
            afp = ?,
            salud = ?,
            domicilio = ?,
            comuna = ?,
            estadoCivil = ?,
            foto = ?,
            telefono = ?,
            correo = ?,
            imagen = ?,
            tipoPago=?,
            banco=?,
            tipoCuenta=?,
            numeroCuenta=?
        WHERE rut = ?
          `,  [nombre, nacimiento, nacionalidad,fechaCreacion, afp, salud, domicilio, comuna, estado, foto, telefono, correo, imagen,tipoPago,banco,tipoCuenta,numeroCuenta, rut]

          );
  
          connection.release();
          console.log('Conexión liberada y devuelta a la piscina.');
          console.log(results); // Puedes mostrar los resultados si lo deseas
          // Envía una respuesta al cliente
          res.json({ message: 'Trabajador editado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
      console.log(error)
    }
  });
  
  
  
  app.post('/finiquitarTrabajador', async(req, res) => {
  try{
      const {rut} = req.body;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      UPDATE trabajadores
      SET estado = 1
      WHERE rut =?
        `,  [rut]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Trabajo editado exitosamente' });
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});

  app.get('/trabajadores', async (req, res) => {
    try{
        // Obtener una conexión de la piscina
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');

    // console.log(req)
        const [results] = await connection.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador GROUP BY trabajadores.rut');
        //console.log(results);
        const trabajadores = results.map((trabajador) => ({
          rut: trabajador.rut,
          nombre: trabajador.nombre,
          nacimiento: trabajador.nacimiento,
          nacionalidad: trabajador.nacionalidad,
          firma: trabajador.firma.toString('base64'),
          afp: trabajador.afp,
          salud: trabajador.salud,
          domicilio: trabajador.domicilio,
          comuna: trabajador.comuna,
          telefono:trabajador.telefono,
          correo:trabajador.correo,
          estadoCivil: trabajador.estadoCivil,
          contratos:trabajador.contratos,
          id: trabajador.id,
          descripcionTrabajo: trabajador.descripcionTrabajo,
          fechaCreacion: trabajador.fechaCreacion,
          sueldo: trabajador.sueldo,
          foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO'),
          tipoPago:trabajador.tipoPago,
          banco:trabajador.banco,
          tipoCuenta:trabajador.tipoCuenta,
          numeroCuenta:trabajador.numeroCuenta,
          estado:trabajador.estado
          }));

          // Devuelve los datos de los trabajadores como respuesta JSON
          //res.json(trabajadores);

        // Liberar la conexión para que vuelva a la piscina
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');

        res.json(trabajadores);
    } catch (error) {
      res.json({ message: error });
    }
   });


   app.get('/trabajadorRut/:rut', async(req, res) => {
    try{
        const {rut} = req.params;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');
        const [results] = await connection.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.rut="'+rut+'" GROUP BY trabajadores.rut');
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        const trabajadores = results.map((trabajador) => ({
          rut: trabajador.rut,
          nombre: trabajador.nombre,
          nacimiento: trabajador.nacimiento,
          nacionalidad: trabajador.nacionalidad,
          firma: trabajador.firma.toString('base64'),
          afp: trabajador.afp,
          salud: trabajador.salud,
          domicilio: trabajador.domicilio,
          comuna: trabajador.comuna,
          telefono:trabajador.telefono,
          correo:trabajador.correo,
          estadoCivil: trabajador.estadoCivil,
          contratos:trabajador.contratos,
          id: trabajador.id,
          descripcionTrabajo: trabajador.descripcionTrabajo,
          fechaCreacion: trabajador.fechaCreacion,
          sueldo: trabajador.sueldo,
          foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO'),
          tipoPago:trabajador.tipoPago,
          banco:trabajador.banco,
          tipoCuenta:trabajador.tipoCuenta,
          numeroCuenta:trabajador.numeroCuenta,
          estado:trabajador.estado
          }));
        res.json(trabajadores);
    } catch (error) {
      res.json({ message: error });
    }
   });

   app.get('/trabajadorNombre/:nombre', async(req, res) => {
    try{
        const {nombre} = req.params;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');
        const [results] = await connection.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.nombre like "%'+nombre+'%" GROUP BY trabajadores.rut');
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        const trabajadores = results.map((trabajador) => ({
          rut: trabajador.rut,
          nombre: trabajador.nombre,
          nacimiento: trabajador.nacimiento,
          nacionalidad: trabajador.nacionalidad,
          firma: trabajador.firma.toString('base64'),
          afp: trabajador.afp,
          salud: trabajador.salud,
          domicilio: trabajador.domicilio,
          comuna: trabajador.comuna,
          telefono:trabajador.telefono,
          correo:trabajador.correo,
          estadoCivil: trabajador.estadoCivil,
          contratos:trabajador.contratos,
          id: trabajador.id,
          descripcionTrabajo: trabajador.descripcionTrabajo,
          fechaCreacion: trabajador.fechaCreacion,
          sueldo: trabajador.sueldo,
          foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO'),
          tipoPago:trabajador.tipoPago,
          banco:trabajador.banco,
          tipoCuenta:trabajador.tipoCuenta,
          numeroCuenta:trabajador.numeroCuenta,
          estado:trabajador.estado
          }));
        res.json(trabajadores);
    } catch (error) {
      res.json({ message: error });
    }
   });


   ////CONTRATOS

   app.post('/registrarContrato', async(req, res) => {
    try{
        const { trabajador,afp,salud,domicilio,comuna,estadoCivil,descripcionTrabajo,fechaCreacion,sueldo,riesgo,gorroEPP,antiparraEPP,bloqueadorEPP,alcoholEPP,usuario} = req.body;
        const contrato = { trabajador,afp,salud,domicilio,comuna,estadoCivil,descripcionTrabajo,fechaCreacion,sueldo,riesgo,gorroEPP,antiparraEPP,bloqueadorEPP,alcoholEPP,usuario};
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.'); 
       
        const [results] = await connection.query('INSERT INTO contratos SET ?', contrato);
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        
        console.log(results); 
        res.json({ message: 'Contrato registrado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
    }
  });



  app.get('/contratos0/:fecha1/:fecha2', async(req, res) => {
    try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');
        console.log(fecha1,fecha2)
        const [results] = await connection.query('SELECT trabajadores.rut,trabajadores.nombre,trabajadores.nacimiento,trabajadores.nacionalidad,trabajadores.firma,trabajadores.foto2, contratos.afp,contratos.salud,contratos.domicilio,contratos.comuna,contratos.estadoCivil,contratos.id,contratos.descripcionTrabajo,contratos.fechaCreacion, contratos.sueldo,contratos.riesgo,contratos.gorroEPP,contratos.antiparraEPP,contratos.bloqueadorEPP,contratos.alcoholEPP, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.estado=0  and contratos.fechaCreacion>="'+fecha1+'" and contratos.fechaCreacion<="'+fecha2+'"  GROUP BY trabajadores.rut');
        console.log(results)
        if (results.length > 0) {
            // Construye un arreglo con los datos de los trabajadores
            try{
              const trabajadores = results.map((trabajador) => ({
                rut: trabajador.rut,
                nombre: trabajador.nombre,
                nacimiento: trabajador.nacimiento,
                nacionalidad: trabajador.nacionalidad,
                firma: trabajador.firma.toString('base64'),
                afp: trabajador.afp,
                salud: trabajador.salud,
                domicilio: trabajador.domicilio,
                comuna: trabajador.comuna,
                estadoCivil: trabajador.estadoCivil,
                contratos:trabajador.contratos,
                id: trabajador.id,
                descripcionTrabajo: trabajador.descripcionTrabajo,
                fechaCreacion: trabajador.fechaCreacion,
                sueldo: trabajador.sueldo,
                riesgo: trabajador.riesgo,
                gorroEPP: trabajador.gorroEPP,
                antiparraEPP: trabajador.antiparraEPP,
                bloqueadorEPP: trabajador.bloqueadorEPP,
                alcoholEPP: trabajador.alcoholEPP,
                foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO')
                }));
    
                // Devuelve los datos de los trabajadores como respuesta JSON
                res.json(trabajadores);
            }catch(error){
              console.log(error)
            }
            
        } else {
            res.sendStatus(404); // Trabajadores no encontrados
        }

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');

    } catch (error) {
        res.json({ message: error });
    }
   });


   
  app.get('/contratos1', async(req, res) => {
    try{
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');

        const [results] = await connection.query('SELECT trabajadores.rut,trabajadores.nombre,trabajadores.nacimiento,trabajadores.nacionalidad,trabajadores.firma,trabajadores.foto2, contratos.afp,contratos.salud,contratos.domicilio,contratos.comuna,contratos.estadoCivil,contratos.id,contratos.descripcionTrabajo,contratos.fechaCreacion, contratos.sueldo,contratos.riesgo,contratos.gorroEPP,contratos.antiparraEPP,contratos.bloqueadorEPP,contratos.alcoholEPP, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.estado=1 GROUP BY trabajadores.rut');

        if (results.length > 0) {
            // Construye un arreglo con los datos de los trabajadores
            try{
              const trabajadores = results.map((trabajador) => ({
                rut: trabajador.rut,
                nombre: trabajador.nombre,
                nacimiento: trabajador.nacimiento,
                nacionalidad: trabajador.nacionalidad,
                firma: trabajador.firma.toString('base64'),
                afp: trabajador.afp,
                salud: trabajador.salud,
                domicilio: trabajador.domicilio,
                comuna: trabajador.comuna,
                estadoCivil: trabajador.estadoCivil,
                contratos:trabajador.contratos,
                id: trabajador.id,
                descripcionTrabajo: trabajador.descripcionTrabajo,
                fechaCreacion: trabajador.fechaCreacion,
                sueldo: trabajador.sueldo,
                riesgo: trabajador.riesgo,
                gorroEPP: trabajador.gorroEPP,
                antiparraEPP: trabajador.antiparraEPP,
                bloqueadorEPP: trabajador.bloqueadorEPP,
                alcoholEPP: trabajador.alcoholEPP,
                foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO')
                }));
    
                // Devuelve los datos de los trabajadores como respuesta JSON
                res.json(trabajadores);
            }catch(error){
              console.log(error)
            }
        } else {
            res.sendStatus(404); // Trabajadores no encontrados
        }

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');

    } catch (error) {
        res.json({ message: error });
    }
   });


   app.get('/contratosRut/:rut', async (req, res) => {
    try{
        const {rut} = req.params;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  
        const [results] = await connection.query('SELECT trabajadores.rut,trabajadores.nombre,trabajadores.nacimiento,trabajadores.nacionalidad,trabajadores.firma, trabajadores.foto2,contratos.afp,contratos.salud,contratos.domicilio,contratos.comuna,contratos.estadoCivil,contratos.id,contratos.descripcionTrabajo,contratos.fechaCreacion, contratos.sueldo,contratos.riesgo,contratos.gorroEPP,contratos.antiparraEPP,contratos.bloqueadorEPP,contratos.alcoholEPP, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.rut="'+rut+'" GROUP BY trabajadores.rut');
     
        if (results.length > 0) {
          try{
            const trabajadores = results.map((trabajador) => ({
              rut: trabajador.rut,
              nombre: trabajador.nombre,
              nacimiento: trabajador.nacimiento,
              nacionalidad: trabajador.nacionalidad,
              firma: trabajador.firma.toString('base64'),
              afp: trabajador.afp,
              salud: trabajador.salud,
              domicilio: trabajador.domicilio,
              comuna: trabajador.comuna,
              estadoCivil: trabajador.estadoCivil,
              contratos:trabajador.contratos,
              id: trabajador.id,
              descripcionTrabajo: trabajador.descripcionTrabajo,
              fechaCreacion: trabajador.fechaCreacion,
              sueldo: trabajador.sueldo,
              riesgo: trabajador.riesgo,
              gorroEPP: trabajador.gorroEPP,
              antiparraEPP: trabajador.antiparraEPP,
              bloqueadorEPP: trabajador.bloqueadorEPP,
              alcoholEPP: trabajador.alcoholEPP,
              foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO')
              }));
  
              // Devuelve los datos de los trabajadores como respuesta JSON
              res.json(trabajadores);
          }catch(error){
            console.log(error)
          }
        } else {
            res.sendStatus(404); // Trabajadores no encontrados
        }
        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
    } catch (error) {
        res.json({ message: error });
    }
   });

   app.get('/contratosNombre/:nombre',async (req, res) => {
    try{
        const {nombre} = req.params;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');  

        const [results] = await connection.query('SELECT trabajadores.rut,trabajadores.nombre,trabajadores.nacimiento,trabajadores.nacionalidad,trabajadores.firma, trabajadores.foto2,contratos.afp,contratos.salud,contratos.domicilio,contratos.comuna,contratos.estadoCivil,contratos.id,contratos.descripcionTrabajo,contratos.fechaCreacion, contratos.sueldo,contratos.riesgo,contratos.gorroEPP,contratos.antiparraEPP,contratos.bloqueadorEPP,contratos.alcoholEPP, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.nombre like "%'+nombre+'%" GROUP BY trabajadores.rut');
      
        if (results.length > 0) {
          try{
            const trabajadores = results.map((trabajador) => ({
              rut: trabajador.rut,
              nombre: trabajador.nombre,
              nacimiento: trabajador.nacimiento,
              nacionalidad: trabajador.nacionalidad,
              firma: trabajador.firma.toString('base64'),
              afp: trabajador.afp,
              salud: trabajador.salud,
              domicilio: trabajador.domicilio,
              comuna: trabajador.comuna,
              estadoCivil: trabajador.estadoCivil,
              contratos:trabajador.contratos,
              id: trabajador.id,
              descripcionTrabajo: trabajador.descripcionTrabajo,
              fechaCreacion: trabajador.fechaCreacion,
              sueldo: trabajador.sueldo,
              riesgo: trabajador.riesgo,
              gorroEPP: trabajador.gorroEPP,
              antiparraEPP: trabajador.antiparraEPP,
              bloqueadorEPP: trabajador.bloqueadorEPP,
              alcoholEPP: trabajador.alcoholEPP,
              foto2:(trabajador.foto2? trabajador.foto2.toString('base64'):'NO')
              }));
  
              // Devuelve los datos de los trabajadores como respuesta JSON
              res.json(trabajadores);
          }catch(error){
            console.log(error)
          }
        } else {
            res.sendStatus(404); // Trabajadores no encontrados
        }

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
    } catch (error) {
        res.json({ message: error });
    }
   });


   ////////TRABAJOS


   app.post('/registrarTrabajo', async(req, res) => {
    try{
        const {fecha,predio,labor,tipo,rut,nombre,cantidad,valor,transportista,valorTransportista,usuario} = req.body;
        const trabajo = { fecha,predio,labor,tipo,rut,nombre,cantidad,valor,transportista,valorTransportista,usuario};
        const connection = await pool.getConnection();
        console.log('Conexión obtenida del pool.'); 
       
        const [results] = await connection.query('INSERT INTO trabajos SET ?', trabajo);
        connection.release();
        console.log('Conexión liberada y devuelta al pool.');
        
        console.log(results); 
        res.json({ message: 'Trabajo registrado exitosamente' });
      
    } catch (error) {
      res.json({ message: error });
    }
  });

  app.post('/registrarCabecera', async(req, res) => {
  try {
     
      const { predio,labor,valorTrabajo,rutTransportista,valorTransportista,fecha} = req.body;
      const cabecera = { predio,labor,valorTrabajo,rutTransportista,valorTransportista,fecha};
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    
      const [results] = await connection.query('INSERT INTO cabeceraarchivos SET ?', cabecera);
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(results); // Puedes mostrar los resultados si lo deseas
      // Envía una respuesta al cliente
      res.json({ message: 'Cabecera registrada exitosamente' });
  
  } catch (error) {
    console.log(error)
    res.json({ message: error });
  }
 
});




app.post('/buscarCabecera', async(req, res) => {
  try{
    const { predio,labor,valorTrabajo,rutTransportista,valorTransportista,fecha} = req.body;
      //const cabecera = { predio,labor,valorTrabajo,rutTransportista,valorTransportista,fecha};
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      select count(*) as total, fechaRegistro from cabeceraarchivos
      WHERE predio =? and labor=? and valorTrabajo=? and rutTransportista=? and valorTransportista=? and fecha=?
        `,  [predio,labor,valorTrabajo,rutTransportista,valorTransportista,fecha]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json(results);
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});


  app.get('/trabajos', async(req, res) => {
    try{
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');

        const [results] = await connection.query('SELECT * from trabajos');

        if (results.length > 0) {
            // Construye un arreglo con los datos de los trabajadores
            const trabajos = results.map((trabajo) => ({
            id:trabajo.id,
            rut: trabajo.rut,
            nombre: trabajo.nombre,
            fecha: trabajo.fecha,
            predio: trabajo.predio,
            labor: trabajo.labor,
            tipo: trabajo.tipo,
            cantidad: trabajo.cantidad,
            valor: trabajo.valor,
            usuario: trabajo.usuario,
            fechaRegistro:trabajo.fechaRegistro,
            
            }));
            // Devuelve los datos de los trabajadores como respuesta JSON
            res.json(trabajos);
        } else {
            res.sendStatus(404); // Trabajadores no encontrados
        }

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');

    } catch (error) {
        res.json({ message: error });
    }
   });

app.get('/trabajos2/:fecha1/:fecha2/:usuario', async(req, res) => {
    try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const {usuario} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select * from trabajos where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" and usuario="'+usuario+'"');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
   });
   

app.post('/editarTrabajo', async(req, res) => {
  try{
      const { id,predio,labor,cantidad,valor} = req.body;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      UPDATE trabajos
      SET predio = ?,
          labor = ?,
          cantidad = ?,
          valor=?
          
      WHERE id =?
        `,  [predio,labor,cantidad,valor,id]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Trabajo editado exitosamente' });
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});


app.post('/editarTrabajosTodos', async(req, res) => {
  try{
      const { id,labor,valor} = req.body;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      UPDATE trabajos
      SET labor = ?,
          valor=?
          
      WHERE id =?
        `,  [labor,valor,id]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Trabajos editado exitosamente' });
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});


app.delete('/eliminarTrabajo/:id', async (req, res) => {
  try {
    const id = req.params.id; // Obtenemos el ID de los parámetros de la URL

    const connection = await pool.getConnection();
    console.log('Conexión obtenida de la piscina.');

    const [results] = await connection.query(
      `
      DELETE FROM trabajos
      WHERE id = ?
      `,
      [id]
    );

    connection.release();
    console.log('Conexión liberada y devuelta a la piscina.');
    console.log(results); // Puedes mostrar los resultados si lo deseas
    // Envía una respuesta al cliente
    res.json({ message: 'Trabajo eliminado exitosamente' });
  } catch (error) {
    res.status(500).json({ error: 'Ocurrió un error al eliminar el trabajo: ' + error.message });
    console.log(error);
  }
});


/////TRANSPORTISTAS
app.post('/registrarTransportista', async(req, res) => {
  try {
     
      const { rut,nombre,telefono,correo,tipoPago,banco,tipoCuenta,numeroCuenta} = req.body;
      const user = { rut,nombre,telefono,correo,tipoPago,banco,tipoCuenta,numeroCuenta};
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    
      const [results] = await connection.query('INSERT INTO transportistas SET ?', user);
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(results); // Puedes mostrar los resultados si lo deseas
      // Envía una respuesta al cliente
      res.json({ message: 'Trabajador registrado exitosamente' });
  
  } catch (error) {
    console.log(error)
    res.json({ message: error });
  }
 
});


app.get('/transportistas', async(req, res) => {
  try{
      const {nombre} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT * from transportistas');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.get('/transportistaNombre/:nombre', async(req, res) => {
  try{
      const {nombre} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT * FROM transportistas  where nombre like "%'+nombre+'%"');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.get('/transportistaRut/:rut', async(req, res) => {
  try{
      const {rut} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT * FROM transportistas  where rut="'+rut+'"');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.post('/editarTransportista', async(req, res) => {
  try{
      const { rut,nombre,telefono,correo,tipoPago,banco,tipoCuenta,numeroCuenta} = req.body;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      UPDATE transportistas
      SET nombre = ?,
          telefono = ?,
          correo = ?,
          tipoPago=?,
          banco=?,
          tipoCuenta=?,
          numeroCuenta=?
      WHERE rut =?
        `,  [nombre,telefono,correo,tipoPago,banco,tipoCuenta,numeroCuenta,rut]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Transportista editado exitosamente' });
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});


///////PAGOS

app.get('/pagos/:fecha1/:fecha2', async(req, res) => {
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select trabajos.rut, trabajadores.nombre,trabajadores.correo,trabajadores.banco,trabajadores.tipoCuenta,trabajadores.numeroCuenta,sum(cantidad*valor) as monto from trabajos left join trabajadores on trabajos.rut=trabajadores.rut where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" and trabajadores.tipoPago="Transferencia" group by rut');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });
 
 app.get('/pagosEfectivo/:fecha1/:fecha2', async(req, res) => {
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select trabajos.rut, trabajos.transportista,transportistas.nombre as nombreTransportista,trabajadores.nombre,trabajadores.correo,trabajadores.banco,trabajadores.tipoCuenta,trabajadores.numeroCuenta,trabajadores.tipoPago,sum(cantidad*valor) as monto from trabajos left join trabajadores on trabajos.rut=trabajadores.rut left join transportistas on trabajos.transportista=transportistas.rut where fecha>="'+fecha1+'" and fecha<="'+fecha2+'"  and trabajadores.tipoPago="Efectivo" group by rut, transportista order by transportistas.nombre');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });


 app.get('/pagosTransportista/:fecha1/:fecha2', async(req, res) => {
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select transportistas.rut,transportistas.nombre,transportistas.correo,transportistas.banco,transportistas.tipoCuenta,transportistas.numeroCuenta,sum(valorTransportista) as monto from trabajos left join transportistas on trabajos.transportista=transportistas.rut where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" group by transportistas.rut');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

  app.get('/buscarFirma/:rut',async (req, res) => {
    try{
        const rut = req.params.rut;
        const connection = await pool.getConnection();
        console.log('Conexión obtenida de la piscina.');
        const [results] = await connection.query('SELECT firma FROM trabajadores WHERE rut = ?', [rut]);
      
        if (results.length > 0) {
            // Devuelve la imagen Blob como respuesta
            res.contentType('image/png'); // Ajusta el tipo de contenido según el tipo de imagen almacenado
            res.end(results[0].firma, 'binary');
        } else {
            res.sendStatus(404);
        }

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
  } catch (error) {
        res.json({ message: error });
  }
  });

////PREDIOS
app.get('/predios', async(req, res) => {
  try{
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT * from predios order by razon asc');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.post('/registrarPredio', async(req, res) => {
  try {
     
      const { rut,razon,comuna,dueño,observacion} = req.body;
      const predio = { rut,razon,comuna,dueño,observacion};
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    
      const [results] = await connection.query('INSERT INTO predios SET ?', predio);
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(results); // Puedes mostrar los resultados si lo deseas
      // Envía una respuesta al cliente
      res.json({ message: 'Predio registrado exitosamente' });
  
  } catch (error) {
    console.log(error)
    res.json({ message: error });
  }
 
});

app.post('/editarPredio', async(req, res) => {
  try{
      const {id,rut,razon,comuna,dueño,observacion} = req.body;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');  
    //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};

    const [results] = await connection.query(
      `
      UPDATE predios
      SET rut=?,
          razon = ?,
          comuna = ?,
          dueño = ?,
          observacion=?
          
      WHERE id =?
        `,  [rut,razon,comuna,dueño,observacion,id]

        );

        connection.release();
        console.log('Conexión liberada y devuelta a la piscina.');
        console.log(results); // Puedes mostrar los resultados si lo deseas
        // Envía una respuesta al cliente
        res.json({ message: 'Predio editado exitosamente' });
    
  } catch (error) {
    res.json({ message: error });
    console.log(error)
  }
});


 //REPORTES

app.get('/reportes1/:fecha1/:fecha2', async(req, res) => {
  //trabajos realizados
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select sum(cantidad) as cantidad,predio,labor,valor, sum(cantidad)*valor as total from trabajos  where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" GROUP by predio,labor,valor');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });
 
 app.get('/reportes11/:fecha1/:fecha2/:predio', async(req, res) => {
  //trabajos realizados
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const {predio} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('select sum(cantidad) as cantidad,predio,labor,valor, sum(cantidad)*valor as total from trabajos  where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" and predio="'+predio+'" GROUP by predio,labor,valor');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.get('/reportes2', async(req, res) => {
  //trabajos realizados
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT trabajadores.rut,trabajadores.nombre, MAX(trabajos.fecha) AS ultimoTrabajo, DATEDIFF(CURRENT_DATE, MAX(trabajos.fecha)) AS diasDiferencia FROM trabajadores LEFT JOIN trabajos ON trabajadores.rut = trabajos.rut GROUP BY trabajadores.rut, trabajadores.nombre order by diasDiferencia desc');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

 app.get('/reportes3/:fecha1/:fecha2', async(req, res) => {
  //trabajos realizados
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT trabajadores.nombre, trabajadores.rut, COUNT(DISTINCT trabajos.fecha) AS dias FROM trabajadores LEFT JOIN trabajos ON trabajadores.rut = trabajos.rut where fecha>="'+fecha1+'" and fecha<="'+fecha2+'" GROUP BY trabajadores.nombre, trabajadores.rut order by dias desc ');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });

app.get('/reportes4/:fecha1/:fecha2/:rut', async(req, res) => {
  //trabajos realizados
  try{
      const {fecha1} = req.params;
      const {fecha2} = req.params;
      const {rut} = req.params;
      const connection = await pool.getConnection();
      console.log('Conexión obtenida de la piscina.');
      const [results] = await connection.query('SELECT * from trabajos where rut="'+rut+'" and fecha>="'+fecha1+'" and fecha<="'+fecha2+'" order by fecha asc ');
      connection.release();
      console.log('Conexión liberada y devuelta a la piscina.');
      console.log(fecha1,fecha2,results)
      res.json(results);
  } catch (error) {
    res.json({ message: error });
  }
 });
app.listen(port, () => {
  console.log(`Servidor en ejecución en http://localhost:${port}`);
});