const express = require('express');
const mysql = require('mysql2');
const bcrypt = require('bcrypt');
const jwt = require('jsonwebtoken');
const cors = require('cors');

const app = express();
const port = 3000;

const db = mysql.createConnection({
  host: 'localhost',
  user: 'williams_mejias',
  password: 'wMej_!234',
  database: 'williams_sistemas'
});

db.connect((err) => {
  if (err) {
    console.error('Error al conectar a la base de datos:', err);
    return;
  }
  console.log('Conexión exitosa a la base de datos');
});

app.use(express.json());
app.use(cors());

// Ruta para registro de usuarios
app.post('/register', (req, res) => {
  const { rut, password } = req.body;

  bcrypt.hash(password, 10, (err, hash) => {
    if (err) {
      console.error('Error al crear el hash de la contraseña:', err);
      res.status(500).json({ error: 'Error al registrar el usuario' });
      return;
    }

    const user = { rut, password: hash };

    db.query('INSERT INTO users SET ?', user, (err, result) => {
      if (err) {
        console.error('Error al registrar el usuario en la base de datos:', err);
        res.status(500).json({ error: 'Error al registrar el usuario' });
        return;
      }

      res.json({ message: 'Usuario registrado exitosamente' });
    });
  });
});






// Ruta para iniciar sesión y obtener un token
app.post('/login', (req, res) => {
  const { rut, password } = req.body;

  db.query('SELECT * FROM usuarios WHERE rut = ?', [rut], (err, results) => {
    if (err) {
      console.error('Error al obtener el usuario de la base de datos:', err);
      res.status(500).json({ error: 'Error al iniciar sesión' });
      return;
    }
    console.log(results.length)
    if (results.length === 0) {
      res.status(401).json({ error: 'Credenciales inválidas' });
      return;
    }

    const user = results[0];

    bcrypt.compare(password, user.password, (err, match) => {
        console.log(password,user.password,match)
      if (err) {
        console.error('Error al comparar las contraseñas:', err);
        res.status(500).json({ error: 'Error al iniciar sesión' });
        return;
      }

      if (!match) {
        res.status(401).json({ error: 'Credenciales inválidas' });
        return;
      }

      const token = jwt.sign({ rut: user.rut }, 'clave_secreta');
      res.json({ token });
    });
  });
});







// Middleware para verificar el token en cada solicitud
app.use((req, res, next) => {
  const token = req.headers.authorization;

  if (token) {
    jwt.verify(token, 'clave_secreta', (err, decoded) => {
      if (err) {
        res.status(401).json({ error: 'Token inválido' });
      } else {
        req.user = decoded;
        next();
      }
    });
  } else {
    res.status(401).json({ error: 'Token requerido' });
  }
});

// Ruta protegida que requiere autenticación
app.get('/protected', (req, res) => {
  res.json({ message: 'Acceso permitido', user: req.user });
});

app.get('/users', (req, res) => {

   // console.log(req)
    db.query('SELECT * FROM usuarios', (err, results) => {
        console.log(err, results)
      if (err) {
        console.error('Error al obtener usuarios:', err);
        res.status(500).json({ error: 'Error al obtener usuarios' });
        return;
      }
      res.json(results);
    });
  });





  app.post('/registrarTrabajador', (req, res) => {
    const { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estadoCivil,foto,telefono,correo} = req.body;
  
   
      const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estadoCivil,foto,telefono,correo};
  
      db.query('INSERT INTO trabajadores SET ?', user, (err, result) => {
        if (err) {
          console.error('Error al registrar el usuario en la base de datos:', err);
          res.status(500).json({ error: 'Error al registrar el usuario' });
          return;
        }
  
        res.json({ message: 'Usuario registrado exitosamente' });
      });
    
  });
  
  app.post('/editarTrabajador', (req, res) => {
    const { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo} = req.body;
  
   
      //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};
  
      db.query(`
          UPDATE trabajadores
          SET nombre = '${nombre}',
          nacimiento = '${nacimiento}',
          nacionalidad = '${nacionalidad}',
          afp = '${afp}',
          salud = '${salud}',
          domicilio = '${domicilio}',
          estado = '${estado}',
          foto = '${foto}',
          telefono = '${telefono}',
          correo = '${correo}'
          WHERE rut = '${rut}'
          `, (err, result) => {
        if (err) {
          console.error('Error al registrar el usuario en la base de datos:', err);
          res.status(500).json({ error: 'Error al registrar el usuario' });
          return;
        }
  
        res.json({ message: 'Usuario registrado exitosamente' });
      });
    
  });

  app.get('/trabajadores', (req, res) => {

    // console.log(req)
     db.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador GROUP BY trabajadores.rut', (err, results) => {
         console.log(err, results)
       if (err) {
         console.error('Error al obtener usuarios:', err);
         res.status(500).json({ error: 'Error al obtener usuarios' });
         return;
       }
       res.json(results);
     });
   });


   app.get('/trabajadorRut/:rut', (req, res) => {
    const {rut} = req.params;
    //console.log(req.body)
    // console.log(req)
     //db.query('SELECT * FROM trabajadores where rut= ?', [rut], (err, results) => {
      db.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador where trabajadores.rut="'+rut+'" GROUP BY trabajadores.rut', (err, results) => {
         console.log(err, results)
       if (err) {
         console.error('Error al obtener usuarios:', err);
         res.status(500).json({ error: 'Error al obtener usuarios' });
         return;
       }
       res.json(results);
     });
   });

   app.get('/trabajadorNombre/:nombre', (req, res) => {
    const {nombre} = req.params;
    //console.log(req.body)
    // console.log(req)
     db.query('SELECT * FROM trabajadores where nombre like "%'+nombre+'%"', (err, results) => {
         console.log(err, results)
       if (err) {
         console.error('Error al obtener usuarios:', err);
         res.status(500).json({ error: 'Error al obtener usuarios' });
         return;
       }
       res.json(results);
     });
   });






   app.get('/contratos', (req, res) => {

    // console.log(req)
     db.query('SELECT trabajadores.*, COUNT(contratos.trabajador) AS contratos, contratos.* FROM trabajadores LEFT JOIN contratos ON trabajadores.rut = contratos.trabajador GROUP BY trabajadores.rut', (err, results) => {
         console.log(err, results)
       if (err) {
         console.error('Error al obtener usuarios:', err);
         res.status(500).json({ error: 'Error al obtener usuarios' });
         return;
       }
       res.json(results);
     });
   });

   app.post('/registrarContrato', (req, res) => {
    const { trabajador,descripcionTrabajo,fechaCreacion,sueldo} = req.body;
  
   
      const contrato = { trabajador,descripcionTrabajo,fechaCreacion,sueldo};
  
      db.query('INSERT INTO contratos SET ?', contrato, (err, result) => {
        if (err) {
          console.error('Error al registrar el contrato en la base de datos:', err);
          res.status(500).json({ error: 'Error al registrar el contrato' });
          return;
        }
  
        res.json({ message: 'contrato registrado exitosamente' });
      });
    
  });


  app.post('/registrarEPP', (req, res) => {
    const { id,gorroEPP,antiparraEPP,bloqueadorEPP,alcoholEPP} = req.body;
  
   
      //const user = { rut,nombre,nacimiento,nacionalidad,afp,salud,domicilio,estado,foto,telefono,correo};
  
      db.query(`
          UPDATE contratos
          SET gorroEPP = ${gorroEPP},
          antiparraEPP = ${antiparraEPP},
          bloqueadorEPP = ${bloqueadorEPP},
          alcoholEPP = ${alcoholEPP},
          riesgo=1
          WHERE id =${id} `, (err, result) => {
        if (err) {
          console.error('Error al registrar el EPP en la base de datos:', err);
          res.status(500).json({ error: 'Error al registrar el EPP' });
          return;
        }
  
        res.json({ message: 'EPP registrado exitosamente' });
      });
    
  });


app.listen(port, () => {
  console.log(`Servidor en ejecución en http://localhost:${port}`);
});
